define(['app', 'angular'], function (app) {
	app.directive('navBar', function (focusService, $timeout, $window) {
		return {
			restrict: 'E',
			transclude : true,
			scope : {
				'buttons' : '=',
				'filter' : '=' //service, disable, defaults, model, callbacks (success, failure)
			},
			templateUrl: 'src/ui-components/nav-bar/nav-bar_template.html',
			link: function(scope, elem, attrs) {
				scope.collapseThreshold = false;
				scope.status = {
					toggleOpen: false
				};

				if (scope.buttons) {
					var leftBtnsNum = scope.buttons.left ? scope.buttons.left.length : 0,
				 		rightBtnsNum = scope.buttons.right ? scope.buttons.right.length : 0;

					if (leftBtnsNum >= 2 || rightBtnsNum >= 2 || (leftBtnsNum + rightBtnsNum >= 2)) {
						scope.collapseThreshold = true;					
					}
					scope.$watch('status.toggleOpen', function (newVal, oldVal) {
						if (newVal === false && oldVal === true) {
							$timeout(function () {
								focusService.focusElement('button.dropdown-toggle');		
							}, 300);
						}
					}, true);
				};

				scope.collapseButtons = function () {
					return $window.innerWidth < 768 && scope.collapseThreshold;
				};

				scope.showCollapseContent = function(){
					var height = elem.find("[collapse]")[0].style.height;
				
					if (!scope.isFilterCollapsed) {
						return true;
					} else {
						return false;
					}
				};
			},
			controller: function ($scope, $state, $window, authenticationService) {
				$scope.isFilterCollapsed = false;
				$scope.toggleFilterState = function() {
					$scope.isFilterCollapsed = !$scope.isFilterCollapsed;
				};
			}
		};
	});
});